<?php
include 'setup.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents("php://input"), true);

if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => $conn->connect_error]);
    exit;
}

$posId = $input["PosId"] ?? null;
$recordId = $input["Id"] ?? null;

if (!$posId && !$recordId) {
    http_response_code(400);
    echo json_encode(["error" => "PosId or Id is required"]);
    exit;
}

// Prepare delete statement
if (!empty($input["Deletions"])) {
    foreach ($input["Deletions"] as $record) {
        $stmt = $conn->prepare("DELETE FROM AllRecords WHERE Identifier = ?");
        $stmt->bind_param("s", $record["Item"]); // Ensure key name matches JSON

        if ($stmt->execute()) {
            echo json_encode(["status" => "✅ Record deleted: " . $record["Identifier"]]);
        } else {
            http_response_code(500);
            echo json_encode(["error" => "❌ Failed to delete record"]);
        }

        $stmt->close();
    }
}

// Close connection after loop
$conn->close();
?>
