<?php
include 'setup.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents("php://input"), true);

if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(["error" => $conn->connect_error]);
    exit;
}

$posId = $input["PosId"] ?? null;

if (!$posId || strlen($posId) > 6) {
    http_response_code(400);
    echo json_encode(["error" => "PosId is required and must not exceed 6 characters."]);
    exit;
}


$date = new DateTime("now", new DateTimeZone("Africa/Nairobi"));
$result = $conn->query("SELECT Last_date FROM AllRecords WHERE TableName='User' LIMIT 1");
$Edata = date("Y-m-d");
if ($result) {
    $row = $result->fetch_assoc();
    if ($row) {
        $Edata = $row["Last_date"];
    }
}

if (!empty($input["SaleRecords"])) {
    foreach ($input["SaleRecords"] as $record) {
        $stmt = $conn->prepare("
            REPLACE INTO AllRecords 
            (Id, Identifier, PosId, PaymentType, TransactionCode, AmountPaid, ClientName, ClientPhone, BankName, DebtDue, SerialNumber, SaleRecordId, ProductName, Price, Quantity, SKU, ExpiryDate, SaleId, Amount, SupplierName, SupplierPhone, Username, Password, Role, Email, Phone, BusinessName, IdNo, Location, PosExpiry,Last_date, Withdrawals, Status, TableName, Issue) 
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)
        ");
        
        $stmt->bind_param(
            "issssssssssssssssssssssssssssssssss",
            $record["Id"],
            $record["Identifier"],
            $posId,
            $record["PaymentType"],
            $record["TransactionCode"],
            $record["AmountPaid"],
            $record["ClientName"],
            $record["ClientPhone"],
            $record["BankName"],
            $record["DebtDue"],
            $record["SerialNumber"],
            $record["SaleRecordId"],
            $record["ProductName"],
            $record["Price"],
            $record["Quantity"],
            $record["SKU"],
            $record["ExpiryDate"],
            $record["SaleId"],
            $record["Amount"],
            $record["SupplierName"],
            $record["SupplierPhone"],
            $record["Username"],
            $record["Password"],
            $record["Role"],
            $record["Email"],
            $record["Phone"],
            $record["BusinessName"],
            $record["IdNo"],
            $record["Location"],
            $record["PosExpiry"],
            $Edata,
            $record["Withdrawals"],
            $record["Status"],
            $record["TableName"],
            $date->format("Y-m-d H:i:s")
        );

        $stmt->execute();
        $stmt->close(); // ✅ Added closing statement
    }
}

echo json_encode(["status" => "✅ Sync complete"]);
?>
