<?php
include 'setup.php';
header('Content-Type: application/json');

$input = json_decode(file_get_contents("php://input"), true);
$posId = $input["PosId"] ?? null;

if (!$posId) {
    http_response_code(400);
    echo json_encode(["error" => "PosId is required"]);
    exit;
}

$data = [];

// Query to get all records where PosId matches
$stmt = $conn->prepare("SELECT * FROM AllRecords WHERE PosId = ?");
$stmt->bind_param("s", $posId);
$stmt->execute();
$result = $stmt->get_result();

// Process results
while ($row = $result->fetch_assoc()) {
    $tableName = $row["TableName"]; // Using TableName column as key

    if (!isset($data[$tableName])) {
        $data[$tableName] = [];
    }

    $data[$tableName][] = $row; // Append the row to the array under this tableName
}


$stmt->close();
$conn->close();

// Return JSON response
echo json_encode($data, JSON_PRETTY_PRINT);
?>
